<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title><?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'twentyten' ), max( $paged, $page ) );

	?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php
	/* We add some JavaScript to pages with the comment form
	 * to support sites with threaded comments (when in use).
	 */
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	/* Always have wp_head() just before the closing </head>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to add elements to <head> such
	 * as styles, scripts, and meta tags.
	 */
	wp_head();
?>
</head>

<body <?php body_class(); ?>>

<!-- ID | UNIVERSE -->
<div id="universe">

	<!-- ID | MENU -->
    <div id="menu">
	<?php
		$args	= array(
			'theme_location'	=> 'top-menu',
			'container'			=> false,
			'menu_class'		=> 'sf-menu',
			'fallback_cb'		=> 'reviewSiteHeaderMenu',
		);
		
		wp_nav_menu($args);
	?>
    </div>
    <!-- ID | END | MENU -->
    
    <!-- ID | TOP-REVIEW -->
   	<div id="top-review">
    	<div id="top-review-background">
           	<div id="top-review-content">
            <h1>Top Ranking</h1>
			<?php reviewSiteTopRating(); ?>
            </div>
        </div>
    </div>
	<!-- ID | END | TOP-REVIEW -->
    
    <!-- ID | HEADER -->
    <div id="header">
		<?php 
			$header_image	= reviewSiteGetOption('home_header_image');
			$header_text	= reviewSiteGetOption('home_header');
			
			if(empty($header_image)) :
				echo $header_text;
			else :
				?><img src="<?php echo $header_image; ?>" alt="" /><?php
			endif;
		?>
    </div>
    <!-- ID | HEADER | END -->